#!/bin/sh

# Fatal trap 18: integer divide fault while in kernel mode
# cpuid = 0; apic id = 00
# instruction pointer     = 0x20:0xffffffff80c310ee
# stack pointer           = 0x28:0xfffffe0131a629e0
# frame pointer           = 0x28:0xfffffe0131a62a30
# code segment            = base 0x0, limit 0xfffff, type 0x1b
#                         = DPL 0, pres 1, long 1, def32 0, gran 1
# processor eflags        = interrupt enabled, resume, IOPL = 0
# current process         = 12 (swi4: clock (0))
# trap number             = 18
# panic: integer divide fault
# cpuid = 0
# time = 1618722013
# KDB: stack backtrace:
# db_trace_self_wrapper() at db_trace_self_wrapper+0x2b/frame 0xfffffe0131a626f0
# vpanic() at vpanic+0x181/frame 0xfffffe0131a62740
# panic() at panic+0x43/frame 0xfffffe0131a627a0
# trap_fatal() at trap_fatal+0x387/frame 0xfffffe0131a62800
# trap() at trap+0xa4/frame 0xfffffe0131a62910
# calltrap() at calltrap+0x8/frame 0xfffffe0131a62910
# --- trap 0x12, rip = 0xffffffff80c310ee, rsp = 0xfffffe0131a629e0, rbp = 0xfffffe0131a62a30 ---
# realtimer_expire_l() at realtimer_expire_l+0xee/frame 0xfffffe0131a62a30
# softclock_call_cc() at softclock_call_cc+0x15d/frame 0xfffffe0131a62b00
# softclock() at softclock+0x66/frame 0xfffffe0131a62b20
# ithread_loop() at ithread_loop+0x279/frame 0xfffffe0131a62bb0
# fork_exit() at fork_exit+0x80/frame 0xfffffe0131a62bf0
# fork_trampoline() at fork_trampoline+0xe/frame 0xfffffe0131a62bf0
# --- trap 0, rip = 0, rsp = 0, rbp = 0 ---
# KDB: enter: panic
# [ thread pid 12 tid 100161 ]
# Stopped at      kdb_enter+0x37: movq    $0,0x1283f9e(%rip)
# db> x/s version
# version: FreeBSD 14.0-CURRENT #0 main-n246123-21afed4b1d1-dirty: Sat Apr 17 07:39:42 CEST 2021
# pho@t2.osted.lan:/usr/src/sys/amd64/compile/PHO
# db>

[ `uname -p` != "amd64" ] && exit 0

. ../default.cfg
cat > /tmp/syzkaller33.c <<EOF
// https://syzkaller.appspot.com/bug?id=38b58493445d524070d1a7cd73612f8cc9d01f39
// autogenerated by syzkaller (https://github.com/google/syzkaller)
// Reported-by: syzbot+5ab360bd3d3e3c5a6e0e@syzkaller.appspotmail.com

#define _GNU_SOURCE

#include <sys/types.h>

#include <pwd.h>
#include <signal.h>
#include <stdarg.h>
#include <stdbool.h>
#include <stdint.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/endian.h>
#include <sys/syscall.h>
#include <sys/wait.h>
#include <time.h>
#include <unistd.h>

static void kill_and_wait(int pid, int* status)
{
  kill(pid, SIGKILL);
  while (waitpid(-1, status, 0) != pid) {
  }
}

static void sleep_ms(uint64_t ms)
{
  usleep(ms * 1000);
}

static uint64_t current_time_ms(void)
{
  struct timespec ts;
  if (clock_gettime(CLOCK_MONOTONIC, &ts))
    exit(1);
  return (uint64_t)ts.tv_sec * 1000 + (uint64_t)ts.tv_nsec / 1000000;
}

static void execute_one(void);

#define WAIT_FLAGS 0

static void loop(void)
{
  int iter __unused = 0;
  for (;; iter++) {
    int pid = fork();
    if (pid < 0)
      exit(1);
    if (pid == 0) {
      execute_one();
      exit(0);
    }
    int status = 0;
    uint64_t start = current_time_ms();
    for (;;) {
      if (waitpid(-1, &status, WNOHANG | WAIT_FLAGS) == pid)
        break;
      sleep_ms(1);
      if (current_time_ms() - start < 5000) {
        continue;
      }
      kill_and_wait(pid, &status);
      break;
    }
  }
}

uint64_t r[1] = {0x0};

void execute_one(void)
{
  intptr_t res = 0;
  res = syscall(SYS_ktimer_create, 0ul, 0ul, 0x200011c0ul);
  if (res != -1)
    r[0] = *(uint32_t*)0x200011c0;
  *(uint64_t*)0x20001200 = 0x800000000000000;
  *(uint64_t*)0x20001208 = 0;
  *(uint64_t*)0x20001210 = 0;
  *(uint64_t*)0x20001218 = 0xa2b;
  syscall(SYS_ktimer_settime, r[0], 1ul, 0x20001200ul, 0ul);
}
int main(void)
{
  syscall(SYS_mmap, 0x20000000ul, 0x1000000ul, 7ul, 0x1012ul, -1, 0ul);
  loop();
  return 0;
}
EOF
mycc -o /tmp/syzkaller33 -Wall -Wextra -O0 /tmp/syzkaller33.c ||
    exit 1

(cd /tmp; timeout 3m ./syzkaller33)

rm -rf /tmp/syzkaller33 /tmp/syzkaller33.c /tmp/syzkaller.*
exit 0
