#!/bin/sh

# panic: Assertion done != job_total_nbytes failed at ../../../kern/sys_socket.c:670
# cpuid = 10
# time = 1649059964
# KDB: stack backtrace:
# db_trace_self_wrapper() at db_trace_self_wrapper+0x2b/frame 0xfffffe069a27fd70
# vpanic() at vpanic+0x17f/frame 0xfffffe069a27fdc0
# panic() at panic+0x43/frame 0xfffffe069a27fe20
# soaio_process_sb() at soaio_process_sb+0x751/frame 0xfffffe069a27feb0
# soaio_kproc_loop() at soaio_kproc_loop+0xa9/frame 0xfffffe069a27fef0
# fork_exit() at fork_exit+0x80/frame 0xfffffe069a27ff30
# fork_trampoline() at fork_trampoline+0xe/frame 0xfffffe069a27ff30
# --- trap 0xc, rip = 0x36633df4a5ca, rsp = 0x36633cd66d98, rbp = 0x36633cd66db0 ---
# KDB: enter: panic
# [ thread pid 36460 tid 546462 ]
# Stopped at      kdb_enter+0x37: movq    $0,0x127b48e(%rip)
# db> x/s version
# version:        FreeBSD 14.0-CURRENT #0 main-n254248-88b3e65fcff2a: Sun Apr  3 11:21:34 CEST 2022\012    pho@mercat1.netperf.freebsd.org:/usr/src/sys/amd64/compile/PHO\012
# db>

[ `uname -p` != "amd64" ] && exit 0

. ../default.cfg
cat > /tmp/syzkaller50.c <<EOF
// https://syzkaller.appspot.com/bug?id=3d4fdc415d285b4de0dbf5709b4f2bb451a0a382
// autogenerated by syzkaller (https://github.com/google/syzkaller)
// Reported-by: syzbot+3b4dc5d1d63e9bd01eda@syzkaller.appspotmail.com

#define _GNU_SOURCE

#include <sys/types.h>

#include <pwd.h>
#include <signal.h>
#include <stdarg.h>
#include <stdbool.h>
#include <stdint.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/endian.h>
#include <sys/syscall.h>
#include <sys/wait.h>
#include <time.h>
#include <unistd.h>

static void kill_and_wait(int pid, int* status)
{
  kill(pid, SIGKILL);
  while (waitpid(-1, status, 0) != pid) {
  }
}

static void sleep_ms(uint64_t ms)
{
  usleep(ms * 1000);
}

static uint64_t current_time_ms(void)
{
  struct timespec ts;
  if (clock_gettime(CLOCK_MONOTONIC, &ts))
    exit(1);
  return (uint64_t)ts.tv_sec * 1000 + (uint64_t)ts.tv_nsec / 1000000;
}

static void execute_one(void);

#define WAIT_FLAGS 0

static void loop(void)
{
  int iter __unused = 0;
  for (;; iter++) {
    int pid = fork();
    if (pid < 0)
      exit(1);
    if (pid == 0) {
      execute_one();
      exit(0);
    }
    int status = 0;
    uint64_t start = current_time_ms();
    for (;;) {
      if (waitpid(-1, &status, WNOHANG | WAIT_FLAGS) == pid)
        break;
      sleep_ms(1);
      if (current_time_ms() - start < 5000)
        continue;
      kill_and_wait(pid, &status);
      break;
    }
  }
}

uint64_t r[2] = {0xffffffffffffffff, 0xffffffffffffffff};

void execute_one(void)
{
  intptr_t res = 0;
  res = syscall(SYS_socket, 0x1cul, 1ul, 0x84);
  if (res != -1)
    r[0] = res;
  *(uint8_t*)0x20000240 = 0x1c;
  *(uint8_t*)0x20000241 = 0x1c;
  *(uint16_t*)0x20000242 = htobe16(0x4e23);
  *(uint32_t*)0x20000244 = 0;
  *(uint64_t*)0x20000248 = htobe64(0);
  *(uint64_t*)0x20000250 = htobe64(1);
  *(uint32_t*)0x20000258 = 0;
  syscall(SYS_bind, r[0], 0x20000240ul, 0x1cul);
  *(uint8_t*)0x20000080 = 0x1c;
  *(uint8_t*)0x20000081 = 0x1c;
  *(uint16_t*)0x20000082 = htobe16(0x4e23);
  *(uint32_t*)0x20000084 = 0;
  *(uint64_t*)0x20000088 = htobe64(0);
  *(uint64_t*)0x20000090 = htobe64(1);
  *(uint32_t*)0x20000098 = 0;
  syscall(SYS_connect, r[0], 0x20000080ul, 0x1cul);
  *(uint32_t*)0x20000000 = r[0];
  *(uint64_t*)0x20000008 = 0;
  *(uint64_t*)0x20000010 = 0x200002c0;
  *(uint64_t*)0x20000018 = 0;
  *(uint32_t*)0x20000020 = 0;
  *(uint32_t*)0x20000024 = 0;
  *(uint64_t*)0x20000028 = 0;
  *(uint32_t*)0x20000030 = 0;
  *(uint32_t*)0x20000034 = 0;
  *(uint64_t*)0x20000038 = 0;
  *(uint64_t*)0x20000040 = 0;
  *(uint64_t*)0x20000048 = 0;
  *(uint32_t*)0x20000050 = 0;
  *(uint32_t*)0x20000054 = 0;
  *(uint32_t*)0x20000058 = 0;
  *(uint32_t*)0x20000060 = 0;
  syscall(SYS_aio_write, 0x20000000ul);
  res = syscall(SYS_fcntl, r[0], 0ul, r[0]);
  if (res != -1)
    r[1] = res;
  *(uint32_t*)0x20001540 = 0;
  memset((void*)0x20001544, 6, 1);
  syscall(SYS_setsockopt, r[1], 0x84, 0x901, 0x20001540ul, 8ul);
}
int main(void)
{
  syscall(SYS_mmap, 0x20000000ul, 0x1000000ul, 7ul, 0x1012ul, -1, 0ul);
  loop();
  return 0;
}
EOF
mycc -o /tmp/syzkaller50 -Wall -Wextra -O0 /tmp/syzkaller50.c || exit 1

kldstat | grep -q sctp   || { kldload sctp.ko && loaded=1; }

(cd ../testcases/swap; ./swap -t 3m -i 10 -l 100) &
for i in `jot 3`; do
	(cd /tmp; timeout 3m ./syzkaller50) &
	pids="$pids $!"
done
for pid in $pids; do
	wait $pid
done
while pkill swap; do :; done
wait

rm -rf /tmp/syzkaller50 /tmp/syzkaller50.c /tmp/syzkaller.*
[ $loaded ] && kldunload sctp.ko
exit 0
