#include <libecc/lib_ecc_config.h>
#ifdef WITH_CURVE_BIGN384V1

#ifndef __EC_PARAMS_BIGN384V1_H__
#define __EC_PARAMS_BIGN384V1_H__
#include <libecc/curves/known/ec_params_external.h>
static const u8 bign384v1_p[] = {
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xc3,
};

TO_EC_STR_PARAM(bign384v1_p);

#define CURVE_BIGN384V1_P_BITLEN 384
static const u8 bign384v1_p_bitlen[] = {
	0x01, 0x80,
};

TO_EC_STR_PARAM(bign384v1_p_bitlen);

#if (WORD_BYTES == 8)     /* 64-bit words */
static const u8 bign384v1_r[] = {
	0x01, 0x3d,
};

TO_EC_STR_PARAM(bign384v1_r);

static const u8 bign384v1_r_square[] = {
	0x01, 0x88, 0x89,
};

TO_EC_STR_PARAM(bign384v1_r_square);

static const u8 bign384v1_mpinv[] = {
	0xec, 0x9e, 0x48, 0xae, 0x6f, 0x71, 0xde, 0x15,
};

TO_EC_STR_PARAM(bign384v1_mpinv);

static const u8 bign384v1_p_shift[] = {
	0x00,
};

TO_EC_STR_PARAM(bign384v1_p_shift);

static const u8 bign384v1_p_normalized[] = {
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xc3,
};

TO_EC_STR_PARAM(bign384v1_p_normalized);

static const u8 bign384v1_p_reciprocal[] = {
	0x00,
};

TO_EC_STR_PARAM(bign384v1_p_reciprocal);

#elif (WORD_BYTES == 4)   /* 32-bit words */
static const u8 bign384v1_r[] = {
	0x01, 0x3d,
};

TO_EC_STR_PARAM(bign384v1_r);

static const u8 bign384v1_r_square[] = {
	0x01, 0x88, 0x89,
};

TO_EC_STR_PARAM(bign384v1_r_square);

static const u8 bign384v1_mpinv[] = {
	0x6f, 0x71, 0xde, 0x15,
};

TO_EC_STR_PARAM(bign384v1_mpinv);

static const u8 bign384v1_p_shift[] = {
	0x00,
};

TO_EC_STR_PARAM(bign384v1_p_shift);

static const u8 bign384v1_p_normalized[] = {
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xc3,
};

TO_EC_STR_PARAM(bign384v1_p_normalized);

static const u8 bign384v1_p_reciprocal[] = {
	0x00,
};

TO_EC_STR_PARAM(bign384v1_p_reciprocal);

#elif (WORD_BYTES == 2)   /* 16-bit words */
static const u8 bign384v1_r[] = {
	0x01, 0x3d,
};

TO_EC_STR_PARAM(bign384v1_r);

static const u8 bign384v1_r_square[] = {
	0x01, 0x88, 0x89,
};

TO_EC_STR_PARAM(bign384v1_r_square);

static const u8 bign384v1_mpinv[] = {
	0xde, 0x15,
};

TO_EC_STR_PARAM(bign384v1_mpinv);

static const u8 bign384v1_p_shift[] = {
	0x00,
};

TO_EC_STR_PARAM(bign384v1_p_shift);

static const u8 bign384v1_p_normalized[] = {
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xc3,
};

TO_EC_STR_PARAM(bign384v1_p_normalized);

static const u8 bign384v1_p_reciprocal[] = {
	0x00,
};

TO_EC_STR_PARAM(bign384v1_p_reciprocal);

#else                     /* unknown word size */
#error "Unsupported word size"
#endif

static const u8 bign384v1_a[] = {
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xc0,
};

TO_EC_STR_PARAM(bign384v1_a);

static const u8 bign384v1_b[] = {
	0x3c, 0x75, 0xdf, 0xe1, 0x95, 0x9c, 0xef, 0x20,
	0x33, 0x07, 0x5a, 0xab, 0x65, 0x5d, 0x34, 0xd2,
	0x71, 0x27, 0x48, 0xbb, 0x0f, 0xfb, 0xb1, 0x96,
	0xa6, 0x21, 0x6a, 0xf9, 0xe9, 0x71, 0x2e, 0x3a,
	0x14, 0xbd, 0xe2, 0xf0, 0xf3, 0xce, 0xbd, 0x7c,
	0xbc, 0xa7, 0xfc, 0x23, 0x68, 0x73, 0xbf, 0x64,
};

TO_EC_STR_PARAM(bign384v1_b);

#define CURVE_BIGN384V1_CURVE_ORDER_BITLEN 384
static const u8 bign384v1_curve_order[] = {
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe,
	0x6c, 0xcc, 0xc4, 0x03, 0x73, 0xaf, 0x7b, 0xbb,
	0x80, 0x46, 0xda, 0xe7, 0xa6, 0xa4, 0xff, 0x0a,
	0x3d, 0xb7, 0xdc, 0x3f, 0xf3, 0x0c, 0xa7, 0xb7,
};

TO_EC_STR_PARAM(bign384v1_curve_order);

static const u8 bign384v1_gx[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
};

TO_EC_STR_PARAM(bign384v1_gx);

static const u8 bign384v1_gy[] = {
	0x5d, 0x43, 0x82, 0x24, 0xa8, 0x2e, 0x9e, 0x9e,
	0x63, 0x30, 0x11, 0x7e, 0x43, 0x2d, 0xbf, 0x89,
	0x3a, 0x72, 0x9a, 0x11, 0xdc, 0x86, 0xff, 0xa0,
	0x05, 0x49, 0xe7, 0x9e, 0x66, 0xb1, 0xd3, 0x55,
	0x84, 0x40, 0x3e, 0x27, 0x6b, 0x2a, 0x42, 0xf9,
	0xea, 0x5e, 0xcb, 0x31, 0xf7, 0x33, 0xc4, 0x51,
};

TO_EC_STR_PARAM(bign384v1_gy);

static const u8 bign384v1_gz[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
};

TO_EC_STR_PARAM(bign384v1_gz);

static const u8 bign384v1_gen_order[] = {
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe,
	0x6c, 0xcc, 0xc4, 0x03, 0x73, 0xaf, 0x7b, 0xbb,
	0x80, 0x46, 0xda, 0xe7, 0xa6, 0xa4, 0xff, 0x0a,
	0x3d, 0xb7, 0xdc, 0x3f, 0xf3, 0x0c, 0xa7, 0xb7,
};

TO_EC_STR_PARAM(bign384v1_gen_order);

#define CURVE_BIGN384V1_Q_BITLEN 384
static const u8 bign384v1_gen_order_bitlen[] = {
	0x01, 0x80,
};

TO_EC_STR_PARAM(bign384v1_gen_order_bitlen);

static const u8 bign384v1_cofactor[] = {
	0x01,
};

TO_EC_STR_PARAM(bign384v1_cofactor);

static const u8 bign384v1_alpha_montgomery[] = {
	0x00,
};
TO_EC_STR_PARAM_FIXED_SIZE(bign384v1_alpha_montgomery, 0);

static const u8 bign384v1_gamma_montgomery[] = {
	0x00,
};
TO_EC_STR_PARAM_FIXED_SIZE(bign384v1_gamma_montgomery, 0);

static const u8 bign384v1_alpha_edwards[] = {
	0x00,
};
TO_EC_STR_PARAM_FIXED_SIZE(bign384v1_alpha_edwards, 0);

static const u8 bign384v1_name[] = "BIGN384V1";
TO_EC_STR_PARAM(bign384v1_name);

static const u8 bign384v1_oid[] = "1.2.112.0.2.0.34.101.45.3.2";
TO_EC_STR_PARAM(bign384v1_oid);

static const ec_str_params bign384v1_str_params = {
	.p = &bign384v1_p_str_param,
	.p_bitlen = &bign384v1_p_bitlen_str_param,
	.r = &bign384v1_r_str_param,
	.r_square = &bign384v1_r_square_str_param,
	.mpinv = &bign384v1_mpinv_str_param,
	.p_shift = &bign384v1_p_shift_str_param,
	.p_normalized = &bign384v1_p_normalized_str_param,
	.p_reciprocal = &bign384v1_p_reciprocal_str_param,
	.a = &bign384v1_a_str_param,
	.b = &bign384v1_b_str_param,
	.curve_order = &bign384v1_curve_order_str_param,
	.gx = &bign384v1_gx_str_param,
	.gy = &bign384v1_gy_str_param,
	.gz = &bign384v1_gz_str_param,
	.gen_order = &bign384v1_gen_order_str_param,
	.gen_order_bitlen = &bign384v1_gen_order_bitlen_str_param,
	.cofactor = &bign384v1_cofactor_str_param,
	.alpha_montgomery = &bign384v1_alpha_montgomery_str_param,
	.gamma_montgomery = &bign384v1_gamma_montgomery_str_param,
	.alpha_edwards = &bign384v1_alpha_edwards_str_param,
	.oid = &bign384v1_oid_str_param,
	.name = &bign384v1_name_str_param,
};

/*
 * Compute max bit length of all curves for p and q
 */
#ifndef CURVES_MAX_P_BIT_LEN
#define CURVES_MAX_P_BIT_LEN    0
#endif
#if (CURVES_MAX_P_BIT_LEN < CURVE_BIGN384V1_P_BITLEN)
#undef CURVES_MAX_P_BIT_LEN
#define CURVES_MAX_P_BIT_LEN CURVE_BIGN384V1_P_BITLEN
#endif
#ifndef CURVES_MAX_Q_BIT_LEN
#define CURVES_MAX_Q_BIT_LEN    0
#endif
#if (CURVES_MAX_Q_BIT_LEN < CURVE_BIGN384V1_Q_BITLEN)
#undef CURVES_MAX_Q_BIT_LEN
#define CURVES_MAX_Q_BIT_LEN CURVE_BIGN384V1_Q_BITLEN
#endif
#ifndef CURVES_MAX_CURVE_ORDER_BIT_LEN
#define CURVES_MAX_CURVE_ORDER_BIT_LEN    0
#endif
#if (CURVES_MAX_CURVE_ORDER_BIT_LEN < CURVE_BIGN384V1_CURVE_ORDER_BITLEN)
#undef CURVES_MAX_CURVE_ORDER_BIT_LEN
#define CURVES_MAX_CURVE_ORDER_BIT_LEN CURVE_BIGN384V1_CURVE_ORDER_BITLEN
#endif

/*
 * Compute and adapt max name and oid length
 */
#ifndef MAX_CURVE_OID_LEN
#define MAX_CURVE_OID_LEN 0
#endif
#ifndef MAX_CURVE_NAME_LEN
#define MAX_CURVE_NAME_LEN 0
#endif
#if (MAX_CURVE_OID_LEN < 1)
#undef MAX_CURVE_OID_LEN
#define MAX_CURVE_OID_LEN 1
#endif
#if (MAX_CURVE_NAME_LEN < 23)
#undef MAX_CURVE_NAME_LEN
#define MAX_CURVE_NAME_LEN 23
#endif

#endif /* __EC_PARAMS_BIGN384V1_H__ */

#endif /* WITH_CURVE_BIGN384V1 */
